
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE

	MSGFINAL TEXT := 'FOI CRIADA';
	
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_NAME= 'pdv_vd_opencashback') THEN 

CREATE TABLE public.PDV_VD_OPENCASHBACK (
	CD_EMP					int4 not null,
	CD_FILIAL				int4 not null,
	CD_VD					int4 not null,
	ID_EXTERNO				varchar(50) null,
	CASHBACK_ACUMULADO		money null,
	CASHBACK_UTILIZADO		money null,
	CASHBACK_SALDO_TOTAL	money null,
	CASHBACK_LIMITE_VENDA	money null,
	AUTENTIC_DOIS_FATORES	int4 null,
	CONFIRMADO				int4 null,	
	CONSTRAINT PDV_VD_OPENCASHBACK_PK PRIMARY KEY (CD_EMP, CD_FILIAL, CD_VD)
);

	ELSE    
		MSGFINAL := 'A TABELA JÁ EXISTE';
	END IF;

	RAISE NOTICE 'TABELA pdv_vd_opencashback %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();


